CREATE SCHEMA IF NOT EXISTS tsystem_security AUTHORIZATION postgres;
COMMENT ON SCHEMA tsystem_security IS 'schema excluded from normal grant mechanisms and SYS.PRODAT-USER. Permissions will be set explicitely and are severly restricted';


DO $$
BEGIN
  CREATE ROLE "FREDA_NFCLOGIN" WITH
    LOGIN
    NOSUPERUSER
    INHERIT
    NOCREATEDB
    NOCREATEROLE
    NOREPLICATION
    ENCRYPTED PASSWORD 'SCRAM-SHA-256$4096:Fhbh32AmEEDlmzqTXwYQ+g==$YcC3zsFg/EkZT6XDdgvrtdD0TT62bNRYHBZiCu8JqgQ=:dmvkuPKCcatX+HmhokOeHH45sisWLOO61jgpJWZK0Tk=';

  COMMENT ON ROLE "FREDA_NFCLOGIN" IS '- master-login to be able to delegate login-auth via NFC for Non-Users (Services)
- PW is under control of the Service';

  EXCEPTION WHEN duplicate_object THEN RAISE NOTICE '%, skipping', SQLERRM USING ERRCODE = SQLSTATE;
END
$$;

